//	TorusGamesAppDelegate-iOS.m
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import "TorusGamesAppDelegate-iOS.h"
#import "TorusGamesRootController.h"
#import "GeometryGamesUtilities-Common.h"
#import "GeometryGamesUtilities-Mac-iOS.h"
#import "GeometryGamesLocalization.h"
#import "GeometryGamesSound.h"


//	Privately-declared properties and methods
@interface TorusGamesAppDelegate()
@end


@implementation TorusGamesAppDelegate
{
	UIWindow	*itsWindow;	//	strong reference keeps window alive
}


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{    
	NSString					*theTwoLetterLanguageCodeAsNSString;
	Char16						theTwoLetterLanguageCode[3];
	TorusGamesRootController	*theRootController;

	UNUSED_PARAMETER(application);
	UNUSED_PARAMETER(launchOptions);

#if TARGET_OS_SIMULATOR
#ifdef GAME_CONTENT_FOR_SCREENSHOT
//	Here's where the screenshots will go.
NSLog(@"Documents directory:  %@",
	NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES)[0]);
#endif
#endif

	//	Create a fallback set of user defaults (the "factory settings").
	//	These will get used if and only if the user has not provided his/her own values.
	[[NSUserDefaults standardUserDefaults] registerDefaults:
		@{
			@"sound effects" : @YES
		}
	];

	//	Get the user's preferred language and convert it to a zero-terminated UTF-16 string.
	theTwoLetterLanguageCodeAsNSString = GetPreferredLanguage();
	[theTwoLetterLanguageCodeAsNSString getCharacters:theTwoLetterLanguageCode range:(NSRange){0,2}];
	theTwoLetterLanguageCode[2] = 0;

	//	Initialize the language code and dictionary to the user's default language.
	SetCurrentLanguage(theTwoLetterLanguageCode);

	//	Initialize the audio.
	SetUpAudio();
	gPlaySounds = GetUserPrefBool(u"sound effects");

	//	Create itsWindow.
	itsWindow = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];

	//	Create the root controller and assign it to the window.
	theRootController = [[TorusGamesRootController alloc] initWithNibName:nil bundle:nil];
	[itsWindow setRootViewController:theRootController];

	//	Show the window.
	[itsWindow makeKeyAndVisible];

#ifdef GAME_CONTENT_FOR_SCREENSHOT
#else
	//	Simulate a tap on the Change Game button,
	//	so the user may choose an initial game.
	//
	//		Caution:  On iOS 13, presenting a popover
	//		immediately at this point would cause a crash.
	//		So we must delay this call by some small amount
	//		(in practice even a delay of 0.0 seconds works fine,
	//		because it delays the call to simulateChangeGameButtonTap
	//		to the next pass through the run loop).
	//		On iOS 12 and earlier the call seemed
	//		to work fine without the delay.
	//		I'm a little embarrassed to write such kludgy code,
	//		but presumably this code will get retired
	//		when I migrate to SwiftUI.
	//
	[theRootController
		performSelector:@selector(simulateChangeGameButtonTap)
		withObject:nil
		afterDelay:0.25];	//	0.0 would be fine (see above), but let's use 0.25 to be safe
#endif

	return YES;
}


@end
